/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.mrp2;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import cz.insophy.inplan.mrp.SupplyJoiner;
import cz.insophy.inplan.mrp.SupplyRequest;
import cz.insophy.inplan.mrp2.MaterialAggHorizonTimeRounder;
import cz.insophy.inplan.mrp2.MaterialIncrementalMrpNamingStrategy;
import cz.insophy.inplan.mrp2.MrpNamingStrategy;
import cz.insophy.inplan.mrp2.TimeRounder;
import cz.insophy.inplan.shop.Material;
import cz.insophy.inplan.store.StoreSchedule;
import cz.insophy.inplan.store.StoreType;
import cz.insophy.inplan.superplan.GeneralizedRequest;
import cz.insophy.inplan.superplan.Superplan;
import cz.insophy.inplan.util.Tuple;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SrAdder {
    private static final Logger log = LoggerFactory.getLogger(SrAdder.class);
    private final Superplan superplan;
    private static final boolean DEFAULT_AGGREGATE = true;
    private static final boolean DEFAULT_USE_SAFETY_STOCK = true;
    private static final boolean DEFAULT_FILL_SAFETY_STOCK_AT_HORIZON = true;
    private static final boolean DEFAULT_USE_BATCHES = true;
    private static final boolean DEFAULT_ADD_SRS_TO_PLAN = false;
    private static final boolean DEFAULT_RESPECT_MATERIAL_HORIZON = true;
    private boolean aggregate;
    private boolean useSafetyStock;
    private boolean fillSafetyStockAtHorizon;
    private boolean useBatches;
    private boolean addSrsToPlan;
    private boolean respectMaterialHorizon;
    private MrpNamingStrategy namingStrategy;
    private TimeRounder timeRounder;

    public SrAdder(Superplan superplan) {
        this.superplan = superplan;
        this.aggregate = true;
        this.useSafetyStock = true;
        this.fillSafetyStockAtHorizon = true;
        this.useBatches = true;
        this.addSrsToPlan = false;
        this.respectMaterialHorizon = true;
    }

    public boolean isAggregate() {
        return this.aggregate;
    }

    public SrAdder setAggregate(boolean aggregate) {
        this.aggregate = aggregate;
        return this;
    }

    public TimeRounder getTimeRounder() {
        return this.timeRounder;
    }

    public SrAdder setTimeRounder(TimeRounder timeRounder) {
        this.timeRounder = timeRounder;
        return this;
    }

    public boolean isUseSafetyStock() {
        return this.useSafetyStock;
    }

    public SrAdder setUseSafetyStock(boolean useSafetyStock) {
        this.useSafetyStock = useSafetyStock;
        return this;
    }

    public boolean isFillSafetyStockAtHorizon() {
        return this.fillSafetyStockAtHorizon;
    }

    public SrAdder setFillSafetyStockAtHorizon(boolean fillSafetyStockAtHorizon) {
        this.fillSafetyStockAtHorizon = fillSafetyStockAtHorizon;
        return this;
    }

    public boolean isUseBatches() {
        return this.useBatches;
    }

    public SrAdder setUseBatches(boolean useBatches) {
        this.useBatches = useBatches;
        return this;
    }

    public boolean isAddSrsToPlan() {
        return this.addSrsToPlan;
    }

    public SrAdder setAddSrsToPlan(boolean addSrsToPlan) {
        this.addSrsToPlan = addSrsToPlan;
        return this;
    }

    public boolean isRespectMaterialHorizon() {
        return this.respectMaterialHorizon;
    }

    public SrAdder setRespectMaterialHorizon(boolean respectMaterialHorizon) {
        this.respectMaterialHorizon = respectMaterialHorizon;
        return this;
    }

    public MrpNamingStrategy getNamingStrategy() {
        return this.namingStrategy;
    }

    public SrAdder setNamingStrategy(MrpNamingStrategy namingStrategy) {
        this.namingStrategy = namingStrategy;
        return this;
    }

    public List<SupplyRequest> run() {
        if (this.superplan.getFixationDate() == -9223372036854775708L && this.useSafetyStock) {
            log.error("Safety stock cannot be generated when the superplan has unset fixation date. Doing nothing.");
            return Lists.newArrayList();
        }
        if (!this.respectMaterialHorizon && this.fillSafetyStockAtHorizon) {
            log.warn("respectMaterialHorizon == false && fillSafetyStockAtHorizon == true");
        }
        if (this.namingStrategy == null) {
            this.namingStrategy = new MaterialIncrementalMrpNamingStrategy(this.superplan);
        }
        ArrayList<SupplyRequest> srs = Lists.newArrayList();
        for (Material material : this.superplan.getShopConf().getMaterials()) {
            List<Tuple<Long, Double>> qties = this.resolveMaterial(material);
            if (qties.isEmpty()) continue;
            List<SupplyRequest> matSrs = this.qtiesToSrs(material, qties);
            srs.addAll(matSrs);
        }
        if (this.addSrsToPlan) {
            for (SupplyRequest sr : srs) {
                this.superplan.addSupplyRequest(sr);
            }
        }
        return srs;
    }

    private List<Tuple<Long, Double>> resolveMaterial(Material material) {
        List<Tuple<Long, Double>> qties;
        if (material.isConsumed()) {
            qties = this.resolveMaterialDirectly(material);
            if (this.timeRounder != null) {
                qties = this.roundTimesForMaterial(material, qties);
            }
            if (this.aggregate || this.useBatches) {
                qties = this.aggregateAndBatchizeMaterial(material, qties);
            }
        } else {
            qties = Collections.emptyList();
        }
        return qties;
    }

    private List<Tuple<Long, Double>> roundTimesForMaterial(Material material, List<Tuple<Long, Double>> qties) {
        Preconditions.checkState(this.timeRounder != null, "timeRounder is null");
        ArrayList<Tuple<Long, Double>> roundedQties = Lists.newArrayListWithCapacity(qties.size());
        long lastR = Long.MIN_VALUE;
        for (Tuple<Long, Double> qty : qties) {
            long t = qty.getFirst();
            long r = this.timeRounder.roundSrTime(material, t);
            if (r > t) {
                log.warn("Rounding of {} for {} moved the event into the future {}.", new Date(t), material, new Date(r));
            }
            if (r < lastR) {
                log.warn("Rounding of {} for {} moved the event to {} which is before the last rounded time {}.", new Date(t), material, new Date(r), new Date(lastR));
            }
            lastR = r;
            roundedQties.add(Tuple.create(r, qty.getSecond()));
        }
        return roundedQties;
    }

    private List<Tuple<Long, Double>> resolveMaterialDirectly(Material material) {
        double q;
        Iterator<Tuple<Long, Double>> it;
        StoreSchedule ss = this.superplan.getPlan().getStoreSchedule(StoreType.ACTUAL_ESTIMATE_VIEW);
        if (this.respectMaterialHorizon) {
            if (!GeneralizedRequest.isDateValid(material.getMaterialHorizon())) {
                return Collections.emptyList();
            }
            it = ss.quantityIterator(material, this.superplan.getFixationDate() + material.getMaterialHorizon());
        } else {
            it = ss.quantityIterator(material);
        }
        ArrayList<Tuple<Long, Double>> newQties = Lists.newArrayList();
        double totalCreatedQty = 0.0;
        double safetyStockCorrection = 0.0;
        long safetyStockTime = Long.MAX_VALUE;
        if (this.useSafetyStock) {
            safetyStockTime = this.superplan.getFixationDate();
            if (this.fillSafetyStockAtHorizon) {
                if (GeneralizedRequest.isDateValid(material.getMaterialHorizon())) {
                    safetyStockTime += material.getMaterialHorizon();
                } else {
                    log.warn("Invalid material horizon of material {} when safety stock ({}) is to be satisfied at horizon.", (Object)material, (Object)material.getSafetyStock());
                }
            }
        }
        while (it.hasNext()) {
            double toAdd;
            double q2;
            Tuple<Long, Double> change = it.next();
            if (change.getFirst() >= safetyStockTime) {
                q2 = ss.getQ(material, safetyStockTime, true) - material.getSafetyStock();
                if (SrAdder.lessThan(q2 + totalCreatedQty, 0.0)) {
                    toAdd = -(totalCreatedQty + q2);
                    newQties.add(Tuple.create(safetyStockTime, toAdd));
                    totalCreatedQty += toAdd;
                }
                safetyStockCorrection = material.getSafetyStock();
                safetyStockTime = Long.MAX_VALUE;
            }
            if (!SrAdder.lessThan((q2 = ss.getQ(material, change.getFirst(), true) - safetyStockCorrection) + totalCreatedQty, 0.0)) continue;
            toAdd = -(totalCreatedQty + q2);
            newQties.add(Tuple.create(change.getFirst(), toAdd));
            totalCreatedQty += toAdd;
        }
        if (safetyStockTime != Long.MAX_VALUE && SrAdder.lessThan((q = ss.getQ(material, safetyStockTime, true) - material.getSafetyStock()) + totalCreatedQty, 0.0)) {
            double toAdd = -(totalCreatedQty + q);
            newQties.add(Tuple.create(safetyStockTime, toAdd));
        }
        return Collections.unmodifiableList(newQties);
    }

    private List<Tuple<Long, Double>> aggregateAndBatchizeMaterial(Material material, List<Tuple<Long, Double>> directQties) {
        double step = material.getBatchStep();
        double min2 = material.getMinBatch();
        double max = material.getMaxBatch();
        ArrayList<Tuple<Long, Double>> qties = Lists.newArrayList();
        double sum = 0.0;
        for (Tuple<Long, Double> qty : directQties) {
            double d = qty.getSecond();
            long t = qty.getFirst();
            sum += d;
            if (qties.isEmpty()) {
                if (this.useBatches) {
                    if (max > 1.0E-7 && SrAdder.greaterThan(sum, max)) {
                        List<Double> batched = SupplyJoiner.getConsolidatedQties(sum, min2, max, step, material);
                        double tq = 0.0;
                        for (Double b : batched) {
                            if (SrAdder.lessThan(b, min2)) {
                                tq += min2;
                                continue;
                            }
                            tq += SrAdder.resolveBatchStep(b, step);
                        }
                        qties.add(Tuple.create(t, tq));
                        sum -= tq;
                        continue;
                    }
                    if (min2 > 1.0E-7 && SrAdder.lessThan(d, min2)) {
                        qties.add(Tuple.create(t, min2));
                        sum -= min2;
                        continue;
                    }
                    if (step > 1.0E-7) {
                        double correctQty = SrAdder.resolveBatchStep(sum, step);
                        qties.add(Tuple.create(t, correctQty));
                        sum -= correctQty;
                        continue;
                    }
                    qties.add(Tuple.create(t, sum));
                    sum = 0.0;
                    continue;
                }
                qties.add(Tuple.create(t, sum));
                sum = 0.0;
                continue;
            }
            if (!SrAdder.greaterThan(sum, 0.0)) continue;
            int lastIdx = qties.size() - 1;
            Tuple last = (Tuple)qties.get(lastIdx);
            if (this.aggregate && t == (Long)last.getFirst()) {
                if (this.useBatches) {
                    double target = (Double)last.getSecond() + sum;
                    if (max > 1.0E-7 && SrAdder.greaterThan(target, max)) {
                        List<Double> batched = SupplyJoiner.getConsolidatedQties(target, min2, max, step, material);
                        double tq = 0.0;
                        for (Double b : batched) {
                            if (SrAdder.lessThan(b, min2)) {
                                tq += min2;
                                continue;
                            }
                            tq += SrAdder.resolveBatchStep(b, step);
                        }
                        sum -= tq - (Double)last.getSecond();
                        qties.set(lastIdx, Tuple.create((Long)last.getFirst(), tq));
                        continue;
                    }
                    if (min2 > 1.0E-7 && SrAdder.lessThan(target, min2)) {
                        sum -= min2 - (Double)last.getSecond();
                        qties.set(lastIdx, Tuple.create((Long)last.getFirst(), min2));
                        continue;
                    }
                    if (step > 1.0E-7) {
                        double correctQty = SrAdder.resolveBatchStep(target, step);
                        sum -= correctQty - (Double)last.getSecond();
                        qties.set(lastIdx, Tuple.create((Long)last.getFirst(), correctQty));
                        continue;
                    }
                    sum -= target - (Double)last.getSecond();
                    qties.set(lastIdx, Tuple.create((Long)last.getFirst(), target));
                    continue;
                }
                qties.set(lastIdx, Tuple.create((Long)last.getFirst(), (Double)last.getSecond() + sum));
                sum = 0.0;
                continue;
            }
            if (this.useBatches) {
                if (max > 1.0E-7 && SrAdder.greaterThan(sum, max)) {
                    List<Double> batched = SupplyJoiner.getConsolidatedQties(sum, min2, max, step, material);
                    double tq = 0.0;
                    for (Double b : batched) {
                        if (SrAdder.lessThan(b, min2)) {
                            tq += min2;
                            continue;
                        }
                        tq += SrAdder.resolveBatchStep(b, step);
                    }
                    qties.add(Tuple.create(t, tq));
                    sum -= tq;
                    continue;
                }
                if (min2 > 1.0E-7 && SrAdder.lessThan(sum, min2)) {
                    qties.add(Tuple.create(t, min2));
                    sum -= min2;
                    continue;
                }
                if (step > 1.0E-7) {
                    double correctQty = SrAdder.resolveBatchStep(sum, step);
                    qties.add(Tuple.create(t, correctQty));
                    sum -= correctQty;
                    continue;
                }
                qties.add(Tuple.create(t, sum));
                sum = 0.0;
                continue;
            }
            qties.add(Tuple.create(t, sum));
            sum = 0.0;
        }
        if (!this.useBatches) {
            return qties;
        }
        ArrayList<Tuple<Long, Double>> finalQties = Lists.newArrayList();
        for (Tuple tuple : qties) {
            for (Double bq : SupplyJoiner.getConsolidatedQties((Double)tuple.getSecond(), min2, max, step, material)) {
                finalQties.add(Tuple.create((Long)tuple.getFirst(), bq));
            }
        }
        return finalQties;
    }

    @VisibleForTesting
    static double resolveBatchStep(double qty, double batchStep) {
        double rem = qty % batchStep;
        if (rem >= 1.0E-7 && rem <= batchStep - 1.0E-7) {
            double n = Math.floor(qty / batchStep);
            double nq = n * batchStep;
            if (SrAdder.lessThan(nq, qty)) {
                nq = (n + 1.0) * batchStep;
            }
            return nq;
        }
        return qty;
    }

    private List<SupplyRequest> qtiesToSrs(Material material, List<Tuple<Long, Double>> qties) {
        Preconditions.checkNotNull(this.namingStrategy);
        ArrayList<SupplyRequest> srs = Lists.newArrayList();
        for (Tuple<Long, Double> qty : qties) {
            String srId = this.namingStrategy.generateSrId(material, qty.getSecond(), qty.getFirst(), SupplyRequest.State.PROPOSED);
            SupplyRequest sr = new SupplyRequest(srId, material, qty.getFirst(), qty.getSecond(), SupplyRequest.State.PROPOSED);
            srs.add(sr);
        }
        return srs;
    }

    private static boolean lessThan(double a, double b) {
        return a < b - 1.0E-7;
    }

    private static boolean greaterThan(double a, double b) {
        return a > b + 1.0E-7;
    }

    @Deprecated
    public static List<SupplyRequest> createSrs(Superplan superplan, boolean aggregate, boolean useSafetyStock, boolean fillSafetyStockAtHorizon, boolean useBatches, boolean addSrsToPlan, boolean respectMaterialHorizon, MrpNamingStrategy namingStrategy) {
        return new SrAdder(superplan).setAggregate(aggregate).setTimeRounder(aggregate ? new MaterialAggHorizonTimeRounder() : null).setUseSafetyStock(useSafetyStock).setFillSafetyStockAtHorizon(fillSafetyStockAtHorizon).setUseBatches(useBatches).setAddSrsToPlan(addSrsToPlan).setRespectMaterialHorizon(respectMaterialHorizon).setNamingStrategy(namingStrategy).run();
    }

    @Deprecated
    public static List<SupplyRequest> createSrs(Superplan superplan, boolean aggregate, boolean useSafetyStock, boolean fillSafetyStockAtHorizon, boolean useBatches, boolean addSrsToPlan, boolean respectMaterialHorizon) {
        return SrAdder.createSrs(superplan, aggregate, useSafetyStock, fillSafetyStockAtHorizon, useBatches, addSrsToPlan, respectMaterialHorizon, null);
    }

    @Deprecated
    public static List<SupplyRequest> createSrs(Superplan superplan, boolean aggregate, boolean useSafetyStock, boolean fillSafetyStockAtHorizon, boolean useBatches, boolean addSrsToPlan) {
        return SrAdder.createSrs(superplan, aggregate, useSafetyStock, fillSafetyStockAtHorizon, useBatches, addSrsToPlan, true, null);
    }

    @Deprecated
    public static List<SupplyRequest> createSrs(Superplan superplan, boolean aggregate, boolean useSafetyStock, boolean fillSafetyStockAtHorizon, boolean useBatches) {
        return SrAdder.createSrs(superplan, aggregate, useSafetyStock, fillSafetyStockAtHorizon, useBatches, true, true, null);
    }
}

